# DX_CC6_CORE_HOST_SIDE makefile
# SST component
#

COMP_NAME := $(SST_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(NVS_ID) $(CRYS_ID) $(VOS_ID) $(CC6_GEN_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)DX_SST6_API/inc/ \
	$(HOST_PATH)DX_SST6_API/tinc/

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)SST6/inc/

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	sst_api_authentication sst_api_data_iterators sst_api_data_operations sst_api_init_terminate sst_api_key_management \
	sst_api_version sst_host_util sst_api_utility sst_api_mm

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)sst_api_authentication.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_authentication.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_data_iterators.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_data_iterators.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_data_operations.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_data_operations.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_init_terminate.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_init_terminate.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_key_management.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_key_management.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_version.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_version.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_host_util.$(OBJEXT): $(HOST_PATH)SST6/src/sst_host_util.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_utility.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_utility.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)sst_api_mm.$(OBJEXT): $(HOST_PATH)SST6/src/sst_api_mm.c
	$(SST_CC_CMD) $< $(CCFLAG_OUTPUT) $@

